<?php

require ABSPATH . 'includes/gump/gump.class.php';
$rules = array(
    'host' => 'required|min_len,3|max_len,255',
    'user' => 'required|min_len,3|max_len,50',
    'pwd' => 'max_len,50',
    'database' => 'required|min_len,3|max_len,50',
    'site_name' => 'required|min_len,3|max_len,255',
    'username' => 'required|min_len,3|max_len,20',
    'password' => 'required|min_len,6|max_len,20',
    'confirm' => 'required|min_len,6|max_len,20',
    'email' => 'required|valid_email|min_len,6|max_len,255',
);

$gump = new GUMP();
$gump->validation_rules($rules);
$validated_data = $gump->run($_POST);
if ($validated_data === false) {
    $errors = $gump->get_readable_errors(false);
}
if (empty($errors['confirm'])) {
    if ($_POST['password'] !== $_POST['confirm']) {
        $errors['same'][] = 'Not same with password';
    }
}